/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.BfileDBAccess;
import oracle.sql.DatumWithConnection;

public class BFILE
extends DatumWithConnection {
    public static final int MAX_CHUNK_SIZE = 32512;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BfileDBAccess dbaccess;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:25:57_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected BFILE() {
    }

    public BFILE(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BFILE(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = this.getInternalConnection().createBfileDBAccess();
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (l2 < 1L || n2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, null);
        }
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = new byte[]{};
        } else {
            long l3 = 0L;
            byte[] byArray2 = new byte[n2];
            l3 = this.getBytes(l2, n2, byArray2);
            if (l3 > 0L) {
                if (l3 == (long)n2) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l3];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l3);
                }
            } else {
                byArray = new byte[]{};
            }
        }
        return byArray;
    }

    public int getBytes(long l2, int n2, byte[] byArray) throws SQLException {
        int n3 = this.getDBAccess().getBytes(this, l2, n2, byArray);
        return n3;
    }

    public InputStream getBinaryStream() throws SQLException {
        InputStream inputStream = this.getDBAccess().newInputStream(this, 32512, 0L);
        return inputStream;
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        long l3 = this.getDBAccess().position(this, byArray, l2);
        return l3;
    }

    public long position(BFILE bFILE, long l2) throws SQLException {
        long l3 = this.getDBAccess().position(this, bFILE, l2);
        return l3;
    }

    public String getName() throws SQLException {
        String string = this.getDBAccess().getName(this);
        return string;
    }

    public String getDirAlias() throws SQLException {
        String string = this.getDBAccess().getDirAlias(this);
        return string;
    }

    public void openFile() throws SQLException {
        this.getDBAccess().openFile(this);
    }

    public boolean isFileOpen() throws SQLException {
        boolean bl = this.getDBAccess().isFileOpen(this);
        return bl;
    }

    public boolean fileExists() throws SQLException {
        boolean bl = this.getDBAccess().fileExists(this);
        return bl;
    }

    public void closeFile() throws SQLException {
        this.getDBAccess().closeFile(this);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        return this.getDBAccess().newInputStream(this, 32512, l2);
    }

    public void open() throws SQLException {
        this.getDBAccess().open(this, 0);
    }

    public void open(int n2) throws SQLException {
        if (n2 != 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 102);
        }
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        boolean bl = string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
        return bl;
    }

    public Reader characterStreamValue() throws SQLException {
        BfileDBAccess bfileDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return bfileDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        BfileDBAccess bfileDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return bfileDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n2) {
        return new BFILE[n2];
    }

    public BfileDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            this.dbaccess = this.getInternalConnection().createBfileDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
        }
        return this.dbaccess;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

