/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    int port;
    String host;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;

    public TcpNTAdapter(String string, Properties properties) throws NLException {
        this.socketOptions = properties;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair2.getAtom();
        if (nVPair3 != null) {
            try {
                this.port = Integer.parseInt(nVPair3.getAtom());
            }
            catch (Exception exception) {
                throw new NLException(new NetException(116).getMessage());
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
    }

    public void connect() throws IOException {
        String string = (String)this.socketOptions.get(new Integer(2));
        if (string != null) {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port), Integer.parseInt(string));
            this.setOption(3, string);
        } else {
            this.socket = new Socket(this.host, this.port);
            String string2 = (String)this.socketOptions.get(new Integer(3));
            if (string2 != null) {
                this.setOption(3, string2);
            }
        }
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        String string = (String)this.socketOptions.get(new Integer(0));
        if (string != null) {
            this.setOption(0, string);
        }
        if ((string = (String)this.socketOptions.get(new Integer(1))) != null) {
            this.setOption(1, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 0: {
                String string = (String)object;
                this.socket.setTcpNoDelay(string.equals("YES"));
                break;
            }
            case 1: {
                String string = (String)object;
                if (!string.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.sockTimeout = Integer.parseInt((String)object);
                this.socket.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    public Object getOption(int n2) throws IOException, NetException {
        switch (n2) {
            case 1: {
                return "" + this.sockTimeout;
            }
        }
        return null;
    }

    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

