/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.NTFRegistration;
import oracle.sql.CharacterSet;

class NTFConnection
extends Thread {
    private static final int NS_HEADER_SIZE = 10;
    private static final int INTERRUPT_SIGNAL = -2;
    private SocketChannel channel;
    private ByteBuffer inBuffer = null;
    private ByteBuffer outBuffer = null;
    private int currentNSPacketLength;
    private int currentNSPacketType;
    private ByteBuffer currentNSPacketDataBuffer;
    private boolean needsToBeClosed = false;
    private NTFManager ntfManager;
    private Selector selector = null;
    private Iterator iterator = null;
    private SelectionKey aKey = null;
    int remotePort;
    String remoteAddress;
    String remoteName;
    int localPort;
    String localAddress;
    String localName;
    String connectionDescription;
    CharacterSet charset = null;
    static final int NSPTCN = 1;
    static final int NSPTAC = 2;
    static final int NSPTAK = 3;
    static final int NSPTRF = 4;
    static final int NSPTRD = 5;
    static final int NSPTDA = 6;
    static final int NSPTNL = 7;
    static final int NSPTAB = 9;
    static final int NSPTRS = 11;
    static final int NSPTMK = 12;
    static final int NSPTAT = 13;
    static final int NSPTCNL = 14;
    static final int NSPTHI = 19;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:11_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    NTFConnection(NTFManager nTFManager, SocketChannel socketChannel) {
        try {
            this.ntfManager = nTFManager;
            this.channel = socketChannel;
            this.channel.configureBlocking(false);
            this.inBuffer = ByteBuffer.allocate(4096);
            this.outBuffer = ByteBuffer.allocate(2048);
            Socket socket = this.channel.socket();
            InetAddress inetAddress = socket.getInetAddress();
            InetAddress inetAddress2 = socket.getLocalAddress();
            this.remotePort = socket.getPort();
            this.localPort = socket.getLocalPort();
            this.remoteAddress = inetAddress.getHostAddress();
            this.remoteName = inetAddress.getHostName();
            this.localAddress = inetAddress2.getHostAddress();
            this.localName = inetAddress2.getHostName();
            this.connectionDescription = "local=" + this.localName + "/" + this.localAddress + ":" + this.localPort + ", remote=" + this.remoteName + "/" + this.remoteAddress + ":" + this.remotePort;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            int n2 = 0;
            this.inBuffer.limit(0);
            while (!this.needsToBeClosed) {
                if (!this.inBuffer.hasRemaining()) {
                    while ((n2 = this.readFromNetwork()) == 0) {
                    }
                }
                if (n2 == -1) break;
                if (n2 == -2) continue;
                this.unmarshalOneNSPacket();
            }
            this.selector.close();
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readFromNetwork() throws IOException {
        this.inBuffer.compact();
        while (true) {
            if (this.iterator == null || !this.iterator.hasNext()) {
                this.selector.select();
                if (this.needsToBeClosed) {
                    return -2;
                }
                this.iterator = this.selector.selectedKeys().iterator();
                continue;
            }
            this.aKey = (SelectionKey)this.iterator.next();
            if ((this.aKey.readyOps() & 1) == 1) break;
        }
        int n2 = this.channel.read(this.inBuffer);
        if (n2 > 0) {
            this.inBuffer.flip();
        }
        this.iterator.remove();
        return n2;
    }

    private void getNextNSPacket() throws IOException {
        if (!this.inBuffer.hasRemaining() || this.inBuffer.remaining() < 10) {
            this.readFromNetwork();
        }
        this.currentNSPacketLength = this.inBuffer.getShort();
        this.inBuffer.position(this.inBuffer.position() + 2);
        this.currentNSPacketType = this.inBuffer.get();
        this.inBuffer.position(this.inBuffer.position() + 5);
        if (this.inBuffer.remaining() < this.currentNSPacketLength - 10) {
            this.readFromNetwork();
        }
        int n2 = this.inBuffer.limit();
        int n3 = this.inBuffer.position() + this.currentNSPacketLength - 10;
        this.inBuffer.limit(n3);
        this.currentNSPacketDataBuffer = this.inBuffer.slice();
        this.inBuffer.limit(n2);
        this.inBuffer.position(n3);
    }

    private void unmarshalOneNSPacket() throws IOException {
        this.getNextNSPacket();
        switch (this.currentNSPacketType) {
            case 1: {
                byte[] byArray = new byte[]{0, 24, 0, 0, 2, 0, 0, 0, 1, 52, 0, 0, 8, 0, 127, -1, 1, 0, 0, 0, 0, 24, 65, 1};
                this.outBuffer.clear();
                this.outBuffer.put(byArray);
                this.outBuffer.limit(24);
                this.outBuffer.rewind();
                this.channel.write(this.outBuffer);
                break;
            }
            case 6: {
                if (this.currentNSPacketDataBuffer.get(0) == -34 && this.currentNSPacketDataBuffer.get(1) == -83) {
                    byte[] byArray = new byte[]{0, 127, 0, 0, 6, 0, 0, 0, 0, 0, -34, -83, -66, -17, 0, 117, 10, 32, 1, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, 0, 31, 0, 14, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 2, 0, 4, 0, 1, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 6, -5, -1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 1, 0, 2, 0};
                    this.outBuffer.clear();
                    this.outBuffer.put(byArray);
                    this.outBuffer.limit(byArray.length);
                    this.outBuffer.rewind();
                    this.channel.write(this.outBuffer);
                    break;
                }
                this.unmarshalNSDataPacket();
            }
        }
    }

    private void unmarshalNSDataPacket() throws IOException {
        int n2;
        int n3;
        int n4;
        short s2 = this.readShort();
        int n5 = this.readInt();
        byte by = this.readByte();
        int n6 = this.readInt();
        short s3 = this.readShort();
        if (this.charset == null || this.charset.getOracleId() != s3) {
            this.charset = CharacterSet.make(s3);
        }
        byte by2 = this.readByte();
        int n7 = this.readInt();
        short s4 = this.readShort();
        byte by3 = this.readByte();
        int n8 = this.readInt();
        short s5 = this.readShort();
        int n9 = (n5 - 21) / 9;
        int[] nArray = new int[n9];
        for (int i2 = 0; i2 < n9; ++i2) {
            byte by4 = this.readByte();
            n4 = this.readInt();
            byte[] byArray = new byte[n4];
            this.readBuffer(byArray, 0, n4);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (i3 >= 4) continue;
                int n10 = i2;
                nArray[n10] = nArray[n10] | byArray[i3] << 8 * (n4 - i3 - 1);
            }
        }
        NTFDCNEvent nTFDCNEvent = null;
        NTFAQEvent nTFAQEvent = null;
        n4 = 0;
        short s6 = 0;
        NTFRegistration[] nTFRegistrationArray = null;
        if (s2 >= 2) {
            n3 = this.readShort();
            nTFRegistrationArray = new NTFRegistration[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nTFRegistrationArray[n2] = this.ntfManager.getRegistration(nArray[n2]);
                if (nTFRegistrationArray[n2] == null) continue;
                n4 = nTFRegistrationArray[n2].getNamespace();
                s6 = nTFRegistrationArray[n2].getDatabaseVersion();
            }
            if (n4 == 2) {
                nTFDCNEvent = new NTFDCNEvent(this, s6);
            } else if (n4 == 1) {
                nTFAQEvent = new NTFAQEvent(this, s6);
            } else if (n4 == 0) {
                // empty if block
            }
        }
        if (s2 >= 3) {
            n3 = this.readShort();
            n2 = this.readInt();
            byte by5 = this.readByte();
            int n11 = this.readInt();
            short s7 = this.readShort();
            if (nTFDCNEvent != null) {
                nTFDCNEvent.setEventType(DatabaseChangeEvent.EventType.DEREG);
            }
            if (nTFAQEvent != null) {
                nTFAQEvent.setEventType(AQNotificationEvent.EventType.DEREG);
            }
        }
        if (s2 > 3) {
            // empty if block
        }
        if (nTFRegistrationArray != null) {
            if (n4 == 2) {
                for (n3 = 0; n3 < nTFRegistrationArray.length; ++n3) {
                    if (nTFRegistrationArray[n3] == null || nTFDCNEvent == null) continue;
                    nTFRegistrationArray[n3].notify(nTFDCNEvent);
                }
            }
            if (n4 == 1) {
                for (n3 = 0; n3 < nTFRegistrationArray.length; ++n3) {
                    if (nTFRegistrationArray[n3] == null || nTFAQEvent == null) continue;
                    nTFRegistrationArray[n3].notify(nTFAQEvent);
                }
            }
        }
    }

    void closeThisConnection() {
        this.needsToBeClosed = true;
    }

    byte readByte() throws IOException {
        byte by = 0;
        if (this.currentNSPacketDataBuffer.hasRemaining()) {
            by = this.currentNSPacketDataBuffer.get();
        } else {
            this.getNextNSPacket();
            by = this.currentNSPacketDataBuffer.get();
        }
        return by;
    }

    short readShort() throws IOException {
        short s2 = 0;
        if (this.currentNSPacketDataBuffer.remaining() >= 2) {
            s2 = this.currentNSPacketDataBuffer.getShort();
        } else {
            int n2 = this.readByte() & 0xFF;
            int n3 = this.readByte() & 0xFF;
            s2 = (short)((n2 << 8 | n3) & 0xFFFF);
        }
        return s2;
    }

    int readInt() throws IOException {
        int n2 = 0;
        if (this.currentNSPacketDataBuffer.remaining() >= 4) {
            n2 = this.currentNSPacketDataBuffer.getInt();
        } else {
            int n3 = this.readByte() & 0xFF;
            int n4 = this.readByte() & 0xFF;
            int n5 = this.readByte() & 0xFF;
            int n6 = this.readByte() & 0xFF;
            n2 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
        }
        return n2;
    }

    long readLong() throws IOException {
        long l2 = 0L;
        if (this.currentNSPacketDataBuffer.remaining() >= 8) {
            l2 = this.currentNSPacketDataBuffer.getLong();
        } else {
            long l3 = (long)this.readByte() & 0xFFL;
            long l4 = (long)this.readByte() & 0xFFL;
            long l5 = (long)this.readByte() & 0xFFL;
            long l6 = (long)this.readByte() & 0xFFL;
            long l7 = (long)this.readByte() & 0xFFL;
            long l8 = (long)this.readByte() & 0xFFL;
            long l9 = (long)this.readByte() & 0xFFL;
            long l10 = (long)this.readByte() & 0xFFL;
            l2 = l3 << 56 | l4 << 48 | l5 << 40 | l6 << 32 | l7 << 24 | l8 << 16 | l9 << 8 | l10;
        }
        return l2;
    }

    void readBuffer(byte[] byArray, int n2, int n3) throws IOException {
        if (this.currentNSPacketDataBuffer.remaining() >= n3) {
            this.currentNSPacketDataBuffer.get(byArray, n2, n3);
        } else {
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = this.currentNSPacketDataBuffer.remaining();
            this.currentNSPacketDataBuffer.get(byArray, n2, n6);
            n2 += n6;
            n4 += n6;
            while (!bl) {
                this.getNextNSPacket();
                n6 = this.currentNSPacketDataBuffer.remaining();
                n5 = Math.min(n6, n3 - n4);
                this.currentNSPacketDataBuffer.get(byArray, n2, n5);
                n2 += n5;
                if ((n4 += n5) != n3) continue;
                bl = true;
            }
        }
    }

    private String packetToString(ByteBuffer byteBuffer) throws IOException {
        int n2 = 0;
        char[] cArray = new char[8];
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            String string = Integer.toHexString(by & 0xFF);
            if ((string = string.toUpperCase()).length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
            cArray[n2] = by > 32 && by < 127 ? (int)by : 46;
            if (++n2 != 8) continue;
            stringBuffer.append('|');
            stringBuffer.append(cArray);
            stringBuffer.append('|');
            stringBuffer.append('\n');
            n2 = 0;
        }
        if (n2 != 0) {
            int n4;
            int n5 = 8 - n2;
            for (n4 = 0; n4 < n5 * 3; ++n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('|');
            stringBuffer.append(cArray, 0, n2);
            for (n4 = 0; n4 < n5; ++n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('|');
            stringBuffer.append('\n');
        }
        stringBuffer.append(new String("\nEnd of Packet\n\n"));
        byteBuffer.position(n3);
        return stringBuffer.toString();
    }
}

