/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import oracle.sql.Datum;
import oracle.sql.utilpack;

public class INTERVALYM
extends Datum {
    private static int MASKVAL = 255;
    private static int INTYMYEAROFFSET = Integer.MIN_VALUE;
    private static int INTYMMONTHOFFSET = 60;
    private static int INTERVALYMMAXLENGTH = 5;
    private static int MAXYEARPREC = 9;
    private static int MAXMONTH = 12;

    public INTERVALYM() {
        super(INTERVALYM._initIntervalYM());
    }

    public INTERVALYM(String string) {
        super(INTERVALYM.toBytes(string));
    }

    public INTERVALYM(byte[] byArray) {
        super(byArray);
    }

    private static byte[] _initIntervalYM() {
        byte[] byArray = new byte[INTERVALYMMAXLENGTH];
        int n2 = 0;
        int n3 = 0;
        byArray[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(n2 += INTYMYEAROFFSET);
        byArray[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(n2);
        byArray[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(n2);
        byArray[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(n2);
        byArray[4] = (byte)(n3 + INTYMMONTHOFFSET);
        return byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.lang.String") == 0;
    }

    public Object makeJdbcArray(int n2) {
        INTERVALYM[] iNTERVALYMArray = new INTERVALYM[n2];
        return iNTERVALYMArray;
    }

    public String stringValue() {
        return INTERVALYM.toString(this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(String string) {
        int n2;
        String string2;
        byte[] byArray = new byte[INTERVALYMMAXLENGTH];
        char c2 = (string2 = string.trim()).charAt(0);
        int n3 = c2 != '-' && c2 != '+' ? 0 : 1;
        String string3 = (string2 = string2.substring(n3)).substring(0, n2 = string2.indexOf(45));
        if (string3.length() > MAXYEARPREC) {
            throw new NumberFormatException();
        }
        int n4 = Integer.valueOf(string3);
        String string4 = string2.substring(n2 + 1);
        int n5 = Integer.valueOf(string4);
        if (n5 >= MAXMONTH) {
            throw new NumberFormatException();
        }
        if (c2 == '-') {
            n4 = -1 * n4;
            n5 = -1 * n5;
        }
        byArray[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(n4 += INTYMYEAROFFSET);
        byArray[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(n4);
        byArray[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(n4);
        byArray[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(n4);
        byArray[4] = (byte)(n5 + INTYMMONTHOFFSET);
        return byArray;
    }

    public Object toJdbc() {
        return this;
    }

    public String toString() {
        return INTERVALYM.toString(this.getBytes());
    }

    public static String toString(byte[] byArray) {
        boolean bl = true;
        int n2 = utilpack.LEFTSHIFTFIRSTNIBBLE(byArray[0]);
        n2 |= utilpack.LEFTSHIFTSECONDNIBBLE(byArray[1]);
        n2 |= utilpack.LEFTSHIFTTHIRDNIBBLE(byArray[2]);
        n2 |= byArray[3] & 0xFF;
        int n3 = byArray[4] - INTYMMONTHOFFSET;
        if ((n2 -= INTYMYEAROFFSET) < 0) {
            bl = false;
            n2 = -n2;
        }
        if (n3 < 0) {
            bl = false;
            n3 = -n3;
        }
        String string = bl ? new String(String.valueOf(n2) + "-" + n3) : new String("-" + n2 + "-" + n3);
        return string;
    }
}

